# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: C

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # First round
        return "C"
    
    # Check if opponent is always cooperating
    if all(move == "C" for move in opp_history):
        if len(my_history) < 9:  # Not the last round
            return "D"
        else:
            return "C"  # Cooperate in the last round to avoid suspicion
    
    # Check if opponent is always defecting
    if all(move == "D" for move in opp_history):
        return "D"
    
    # Check if opponent's code is simple and always defects
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent's code is simple and always cooperates
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        if len(my_history) < 9:
            return "D"
        else:
            return "C"
    
    # Default to Tit-for-Tat with 10% forgiveness
    if opp_history[-1] == "D":
        if random.random() < 0.1:  # 10% chance to forgive
            return "C"
        else:
            return "D"
    else:
        return "C"